% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OverExpectedHiC.R
\name{OverExpectedHiC}
\alias{OverExpectedHiC}
\title{Genomic distance bias correction.}
\usage{
OverExpectedHiC(
  hicLst,
  method = "mean_non_zero",
  verbose = FALSE,
  cores = 1,
  plot_contact_vs_dist = "per_seq"
)
}
\arguments{
\item{hicLst}{<List\link[InteractionSet:ContactMatrix-class]{ContactMatrix}>:
The HiC maps list.}

\item{method}{\if{html}{\out{<character>}} Options are "mean_non_zero",
"mean_total", or "lieberman". Look at details for more.
(Default: "mean_non_zero")}

\item{verbose}{\if{html}{\out{<logical>}}: Show the progression in console?
(Default FALSE)}

\item{cores}{\if{html}{\out{<numerical>}} : Number of cores to be used.
(Default 1)}

\item{plot_contact_vs_dist}{Whether to plot
contact vs distance curve per chromosome ("per_seq"),
all chromosomes ("total") or not (NULL). (Default "per_seq")}
}
\value{
A matrices list.
}
\description{
Function that normalises HiC matrices by expected values
computed per genomic distance.
}
\details{
OverExpectedHiC

Methods to calculate expected values per distance:
\itemize{
\item "mean_non_zero": for each distance, average contact value is
calculated using only non-zero values.
\item "mean_total": for each distance, average contact value is
calculated using all values at this distance.
\item "lieberman": for each distance, contact values are summed and
divided by chromsome length minus distance. Only for cis contacts.
}
}
\examples{
# Note: run HicAggR::BalanceHiC before OverExpectedHiC calculation.
data(HiC_Ctrl.cmx_lst)
OverExpectedHiC(HiC_Ctrl.cmx_lst)

}
