% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilda_plot.R
\name{hildaBarplot}
\alias{hildaBarplot}
\title{Read the raw mutation data with the mutation feature vector format,
  estimate and plot both mutation signatures and their fractions}
\usage{
hildaBarplot(
  inputG,
  hildaResult,
  sigOrder = NULL,
  refGroup,
  sortSampleNum = TRUE,
  refName = "Control",
  altName = "Case",
  charSize = 3
)
}
\arguments{
\item{inputG}{a MutationFeatureData S4 class output by the pmsignature.}

\item{hildaResult}{a rjags class output by HiLDA.}

\item{sigOrder}{the order of signatures if needed (default: NULL).}

\item{refGroup}{the samples in the reference group (default: NULL).}

\item{sortSampleNum}{whether to sort plots by number of mutations
(default: TRUE).}

\item{refName}{the name of reference group (default: Control)}

\item{altName}{the name of the other group (default: Case)}

\item{charSize}{the size of the character on the signature plot (default: 3)}
}
\value{
a list of a signature plot and a barplot of mutational exposures
}
\description{
Read the raw mutation data with the mutation feature vector format,
  estimate and plot both mutation signatures and their fractions
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))
inputFile <- system.file("extdata/hildaLocal.rdata", package="HiLDA")
hildaLocal <- readRDS(inputFile)

hildaBarplot(G, hildaLocal, refGroup=1:4)

}
