# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Update the auxiliary parameters theta and normalize them so that the 
#' summation of each group sums to 1 (E-step),
#' also calculate the current log-likelihood value
#' 
#' @param vPatternList The list of possible mutation features (converted to a 
#' vector)
#' @param vSparseCount The table showing (mutation feature, sample, the number 
#' of mutation) (converted to a vector)
#' @param vF F (converted to a vector)
#' @param vQ Q (converted to a vector)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @param patternNum the number of possible combinations of all the mutation 
#' features
#' @param samplePatternNum the number of possible combination of samples and 
#' mutation patternns
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @param vF0 a background mutaiton features
#' @return a value for theta
updateTheta_NormalizedC <- function(vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0) {
    .Call('_HiLDA_updateTheta_NormalizedC', PACKAGE = 'HiLDA', vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0)
}

#' Calculate the value of the log-likelihood for given parameters
#' 
#' @param vPatternList The list of possible mutation features (converted 
#' to a vector)
#' @param vSparseCount The table showing (mutation feature, sample, the number 
#' of mutation) (converted to a vector)
#' @param vF F (converted to a vector)
#' @param vQ Q (converted to a vector)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @param patternNum the number of possible combinations of all the mutation 
#' features
#' @param samplePatternNum the number of possible combination of samples and 
#' mutation patternns
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @param vF0 a background mutaiton features
#' @return a value 
getLogLikelihoodC <- function(vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0) {
    .Call('_HiLDA_getLogLikelihoodC', PACKAGE = 'HiLDA', vPatternList, vSparseCount, vF, vQ, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground, vF0)
}

#' Update the parameter F and Q (M-step in the EM-algorithm)
#' 
#' @param vPatternList The list of possible mutation features (converted 
#' to a vector)
#' @param vSparseCount The table showing (mutation feature, sample, the number 
#' of mutation) (converted to a vector)
#' @param nTheta The parameters in the distribution
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @param patternNum the number of possible combinations of all the mutation 
#' features
#' @param samplePatternNum the number of possible combination of samples and 
#' mutation patternns
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @return a vector
updateMstepFQC <- function(vPatternList, vSparseCount, nTheta, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground) {
    .Call('_HiLDA_updateMstepFQC', PACKAGE = 'HiLDA', vPatternList, vSparseCount, nTheta, fdim, signatureNum, sampleNum, patternNum, samplePatternNum, isBackground)
}

#' Check whether the parameter F is within the appropriate range
#' 
#' @param turboF F (converted for turboEM)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @return a logical value
boundaryTurbo_F <- function(turboF, fdim, signatureNum) {
    .Call('_HiLDA_boundaryTurbo_F', PACKAGE = 'HiLDA', turboF, fdim, signatureNum)
}

#' Check whether the parameter Q is within the appropriate range
#' 
#' @param turboQ Q (converted for turboEM)
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @return a logical value
boundaryTurbo_Q <- function(turboQ, signatureNum, sampleNum) {
    .Call('_HiLDA_boundaryTurbo_Q', PACKAGE = 'HiLDA', turboQ, signatureNum, sampleNum)
}

#' Convert the parameter Q so that turboEM can treat
#' 
#' @param vQ Q (converted to a vector)
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @return a vector
convertToTurbo_Q <- function(vQ, signatureNum, sampleNum) {
    .Call('_HiLDA_convertToTurbo_Q', PACKAGE = 'HiLDA', vQ, signatureNum, sampleNum)
}

#' Convert the parameter F so that turboEM can treat
#' 
#' @param vF F (converted to a vector)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @return a vector
convertToTurbo_F <- function(vF, fdim, signatureNum, isBackground) {
    .Call('_HiLDA_convertToTurbo_F', PACKAGE = 'HiLDA', vF, fdim, signatureNum, isBackground)
}

#' Restore the converted parameter Q for turboEM
#' 
#' @param turboQ Q (converted for turboEM)
#' @param signatureNum the number of mutation signatures
#' @param sampleNum the number of cancer genomes
#' @return a vector 
convertFromTurbo_Q <- function(turboQ, signatureNum, sampleNum) {
    .Call('_HiLDA_convertFromTurbo_Q', PACKAGE = 'HiLDA', turboQ, signatureNum, sampleNum)
}

#' Restore the converted parameter F for turboEM
#' 
#' @param turboF F (converted for turboEM)
#' @param fdim a vector specifying the number of possible values for each 
#' mutation signature
#' @param signatureNum the number of mutation signatures
#' @param isBackground the logical value showing whether a background mutaiton 
#' features is included or not
#' @return a vector
convertFromTurbo_F <- function(turboF, fdim, signatureNum, isBackground) {
    .Call('_HiLDA_convertFromTurbo_F', PACKAGE = 'HiLDA', turboF, fdim, signatureNum, isBackground)
}

