% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalogram.R
\name{scalogram}
\alias{scalogram}
\title{Compute a scalogram of contacts}
\usage{
scalogram(x, dist_min = 0, nbins = 250, probs = c(0.25, 0.5, 0.75))
}
\arguments{
\item{x}{A \code{HiCExperiment} object}

\item{dist_min}{Minimum distance for interactions to be considered.}

\item{nbins}{Number of bins to divide each chromosome}

\item{probs}{Quantiles of interactions}
}
\value{
a tibble

a tibble
}
\description{
Compute a scalogram of contacts
}
\examples{
contacts_yeast <- HiCExperiment::contacts_yeast()
pairsFile(contacts_yeast) <- HiContactsData::HiContactsData(
  'yeast_wt', format = 'pairs.gz'
)
scalo <- scalogram(contacts_yeast['II'])
scalo
}
