% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KRnormalization.R
\name{KRnorm}
\alias{KRnorm}
\title{Performs KR (Knight-Ruiz) normalization on a Hi-C matrix}
\usage{
KRnorm(A)
}
\arguments{
\item{A}{the matrix to be normalized - any columns/rows of
0's will be removed before being normalized.}
}
\value{
A KR normalized matrix
}
\description{
Performs KR (Knight-Ruiz) normalization on a Hi-C matrix
}
\details{
Performs KR normalization. The function is a translation
    of the `Matlab` code provided in the 2012 manuscript.
    Knight PA, Ruiz D. A fast algorithm for matrix balancing. IMA
    Journal of Numerical Analysis. Oxford University Press; 2012; drs019.
}
\examples{
m <- matrix(rpois(100, 5), 10, 10)
KRnorm(m)
}
