% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakmatrix2list.R
\name{peakmatrix2list}
\alias{peakmatrix2list}
\title{Creates a list of HiCaptuRe objects based on a peakmatrix}
\usage{
peakmatrix2list(peakmatrix, cutoff = 5)
}
\arguments{
\item{peakmatrix}{HiCaptuRe object of a peakmatrix}

\item{cutoff}{Chicago score cut-off to filter interactions}
}
\value{
A named list of \code{HiCaptuRe} objects, each corresponding to a sample (inferred from CS_* columns in the peakmatrix).
}
\description{
This function creates a list of HiCaptuRe objects separating all the samples included on a peakmatrix.
}
\examples{
peakmatrix <- system.file("extdata", "peakmatrix_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(peakmatrix, select_chr = "19")
interactions_list <- peakmatrix2list(peakmatrix = interactions)

}
