% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_summary.R
\name{distance_summary}
\alias{distance_summary}
\title{Computes the number of interactions by distance}
\usage{
distance_summary(interactions, breaks = seq(0, 10^6, 10^5), sample = "sample")
}
\arguments{
\item{interactions}{GenomicInteractions object from \code{\link{load_interactions}}}

\item{breaks}{vector with breaks for split distances}

\item{sample}{character variable with the name of the sample}
}
\value{
list with 2 tables: short_int_dist_table and long_int_dist_table, with the number of short interactions and long interactions respectively
}
\description{
This function computes the number of interactions by distance for a given GenomicInteractions object
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions1 <- load_interactions(ibed1, select_chr = "19")
df <- distance_summary(interactions = interactions1)

}
