% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hicproParser.R
\name{parseHiCPro}
\alias{parseHiCPro}
\title{Parser for HiCPro data}
\usage{
parseHiCPro(matrixPaths, bedPaths, conditions, replicates)
}
\arguments{
\item{matrixPaths}{A vector of paths to HiC-Pro matrix files.}

\item{bedPaths}{A vector of paths to HiC-Pro bed files.}

\item{conditions}{A vector of condition names repeated along the replicates.}

\item{replicates}{A vector of replicate names repeated along the conditions.}
}
\value{
An InteractionSet.
}
\description{
Parses interactions in pairs of \code{.matrix} and \code{.bed} files and
returns an InteractionSet object.
}
\examples{
# Path to each matrix file
matrixPaths <- c(
    "path/to/condition-1.replicate-1.matrix",
    "path/to/condition-1.replicate-2.matrix",
    "path/to/condition-1.replicate-3.matrix",
    "path/to/condition-2.replicate-1.matrix",
    "path/to/condition-2.replicate-2.matrix",
    "path/to/condition-2.replicate-3.matrix"
)

# Path to each bed file
bedPaths <- c(
    "path/to/condition-1.replicate-1.bed",
    "path/to/condition-1.replicate-2.bed",
    "path/to/condition-1.replicate-3.bed",
    "path/to/condition-2.replicate-1.bed",
    "path/to/condition-2.replicate-2.bed",
    "path/to/condition-2.replicate-3.bed"
)

# Condition and replicate of each file. Can be names instead of numbers.
conditions <- c(1, 1, 1, 2, 2, 2)
replicates <- c(1, 2, 3, 1, 2, 3)

if (FALSE) {
    # Instantiation of data set
    hic.experiment <- parseHiCPro(
        matrixPaths = matrixPaths,
        bedPaths = bedPaths,
        conditions = conditions,
        replicates = replicates
    )
}

}
