test_that("CoolFile works", {
    
    expect_no_error(availableChromosomes(coolPath))
    expect_no_error(availableChromosomes(mcoolPath))
    expect_no_error(availableResolutions(coolPath))
    expect_no_error(availableResolutions(mcoolPath))
    # Prepare paths and CoolFiles
    cf0 <- CoolFile(coolPath)
    cf1 <- CoolFile(coolPath, pairsFile = pairsPath)
    mcf0 <- CoolFile(mcoolPath)
    mcf1 <- CoolFile(mcoolPath, pairsFile = pairsPath)
    mcf2 <- CoolFile(mcoolPath, pairsFile = pairsPath, resolution = 16000)
    mcf3 <- CoolFile(mcoolPath, resolution = 16000)
    expect_no_error(availableChromosomes(cf0))
    expect_no_error(availableChromosomes(mcf0))
    expect_no_error(availableResolutions(cf0))
    expect_no_error(availableResolutions(mcf0))

    # No errors/warnings when printing CoolFile
    expect_no_warning(show(cf0))
    expect_no_warning(cf0)
    expect_no_error(cf0)
    expect_no_warning(cf1)
    expect_no_error(cf1)
    expect_no_warning(mcf0)
    expect_no_error(mcf0)
    expect_no_warning(mcf1)
    expect_no_error(mcf1)
    expect_no_warning(mcf2)
    expect_no_error(mcf2)
    expect_no_warning(mcf3)
    expect_no_error(mcf3)

    # Resolution(s) are properly handled
    expect_null(resolution(cf0))
    expect_null(resolution(cf1))
    expect_equal(resolution(mcf0), 1000L)
    expect_equal(resolution(mcf1), 1000L)
    expect_equal(resolution(mcf2), 16000L)
    expect_equal(resolution(mcf3), 16000L)
    expect_no_error(CoolFile(coolPath, 1000L))
    expect_error(CoolFile(coolPath, 2000L))
    expect_error(CoolFile(mcoolPath, 2))
    expect_no_error(metadata(mcf0) <- list(test = 'OK'))

    # pairFile is properly handled
    expect_null(pairsFile(cf0))
    expect_equal(pairsFile(cf1), pairsPath)
    expect_null(pairsFile(mcf0))
    expect_equal(pairsFile(mcf1), pairsPath)
    expect_equal(pairsFile(mcf2), pairsPath)
    expect_null(pairsFile(mcf3))

    # import is properly handled for CoolFile
    expect_no_error(
        icf0 <- import(cf0, focus = 'I')
    )
    expect_no_error(
        icf1 <- import(cf1, focus = 'I')
    )
    expect_no_error(
        imcf0 <- import(mcf0, focus = 'I')
    )
    expect_no_error(
        imcf1 <- import(mcf1, focus = 'I')
    )
    expect_no_error(
        imcf2 <- import(mcf2)
    )
    expect_no_error(
        imcf3 <- import(mcf3)
    )
    expect_no_error(
        imcf4 <- import(mcf3, focus = 'I')
    )
    expect_no_error(
        imcf5 <- import(mcf3, resolution = 4000, focus = 'I', metadata = list(test = 'test'))
    )
    expect_equal(resolution(icf0), 1000L)
    expect_null(pairsFile(icf0))
    expect_equal(resolution(icf1), 1000L)
    expect_equal(pairsFile(icf1), pairsPath)
    expect_equal(resolution(imcf0), 1000L)
    expect_null(pairsFile(imcf0))
    expect_equal(resolution(imcf1), 1000L)
    expect_equal(pairsFile(imcf1), pairsPath)
    expect_equal(resolution(imcf2), 16000L)
    expect_equal(pairsFile(imcf2), pairsPath)
    expect_equal(resolution(imcf3), 16000L)
    expect_null(pairsFile(imcf3))
    expect_null(focus(imcf3))
    expect_equal(metadata(imcf3), list())
    expect_equal(resolution(imcf4), 16000L)
    expect_null(pairsFile(imcf4))
    expect_equal(focus(imcf4), "I")
    expect_equal(resolution(imcf5), 4000L)
    expect_null(pairsFile(imcf5))
    expect_equal(metadata(imcf5), list(test = 'test'))
    expect_equal(focus(imcf5), "I")

    # import is properly handled for files provided as string
    icf0 <- import(coolPath, focus = 'I', format = 'cool')
    icf1 <- import(coolPath, focus = 'I', pairsFile = pairsPath, format = 'cool')
    imcf0 <- import(mcoolPath, focus = 'I', format = 'cool')
    imcf1 <- import(mcoolPath, focus = 'I', pairsFile = pairsPath, format = 'cool')
    imcf2 <- import(mcoolPath, pairsFile = pairsPath, resolution = 16000, format = 'cool')
    imcf3 <- import(mcoolPath, resolution = 16000, format = 'cool')
    imcf4 <- import(mcoolPath, focus = 'I', format = 'cool')
    imcf5 <- import(mcoolPath, resolution = 4000, focus = 'I', metadata = list(test = 'test'), format = 'cool')
    expect_equal(resolution(icf0), 1000L)
    expect_null(pairsFile(icf0))
    expect_equal(resolution(icf1), 1000L)
    expect_equal(pairsFile(icf1), pairsPath)
    expect_equal(resolution(imcf0), 1000L)
    expect_null(pairsFile(imcf0))
    expect_equal(resolution(imcf1), 1000L)
    expect_equal(pairsFile(imcf1), pairsPath)
    expect_equal(resolution(imcf2), 16000L)
    expect_equal(pairsFile(imcf2), pairsPath)
    expect_equal(resolution(imcf3), 16000L)
    expect_null(pairsFile(imcf3))
    expect_equal(resolution(imcf4), 1000L)
    expect_null(pairsFile(imcf4))
    expect_equal(focus(imcf4), "I")
    expect_equal(resolution(imcf5), 4000L)
    expect_null(pairsFile(imcf5))
    expect_equal(metadata(imcf5), list(test = 'test'))
    expect_equal(focus(imcf5), "I")

    # import is properly handled with HiCExperiment function
    expect_no_error(HiCExperiment(coolPath, focus = 'I'))
    expect_error(HiCExperiment(mcoolPath, focus = 'I'))
    expect_error(HiCExperiment(mcoolPath))
    ihf2 <- HiCExperiment(mcoolPath, focus = 'I', resolution = 16000)
    ihf3 <- HiCExperiment(mcoolPath, resolution = 16000, pairsFile = pairsPath)
    expect_equal(resolution(ihf2), 16000L)
    expect_equal(focus(ihf2), 'I')
    expect_null(pairsFile(ihf2))
    expect_equal(resolution(ihf3), 16000L)
    expect_null(focus(ihf3))
    expect_equal(pairsFile(ihf3), pairsPath)
    expect_equal(resolution(ihf3), 16000L)
    expect_null(focus(ihf3))

    # Import works for all possible combinations of ranges 
    expect_no_error(import(mcf1))
    expect_no_error(import(mcf1, focus = 'I'))
    expect_no_error(import(mcf1, focus = 'I:1-40000'))
    expect_no_error(import(mcf1, focus = 'I|II'))
    expect_no_error(import(mcf1, focus = 'III|II'))
    expect_no_error(import(mcf1, focus = 'III:30001-40000|II:10001-40000'))

})
