% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HicproFile-class.R, R/HicproFile-methods.R
\name{HicproFile-class}
\alias{HicproFile-class}
\alias{HicproFile}
\alias{HicproFile-methods}
\alias{show,HicproFile-method}
\title{\code{HicproFile} S4 class}
\arguments{
\item{path}{String; path to the HiC-Pro output .matrix file (matrix file)}

\item{bed}{String; path to the HiC-Pro output .bed file (regions file)}

\item{pairsFile}{String; path to a pairs file}

\item{metadata}{list.}

\item{object}{A \code{HicproFile} object.}
}
\description{
The \code{HicproFile} class describes a \code{BiocFile} object, pointing to the location
of a HiC-Pro-generated matrix file and containing 4 additional slots:
\enumerate{
\item bed: path to the matching \code{.bed} file generated by HiC-Pro;
\item resolution: at which resolution the associated mcool file should be parsed ;
\item pairsFile: the path (in plain character) to an optional pairs file
(stored as a \code{PairsFile} object);
\item metadata: a list metadata
}

HicproFile methods.
}
\section{Slots}{

\describe{
\item{\code{bed}}{Path to the matching \code{.bed} file generated by HiC-Pro}
}}

\examples{
hicproMatrixPath <- HiContactsData::HiContactsData('yeast_wt', 'hicpro_matrix')
hicproBedPath <- HiContactsData::HiContactsData('yeast_wt', 'hicpro_bed')
pairsPath <- HiContactsData::HiContactsData('yeast_wt', 'pairs.gz')
hicpro <- HicproFile(
  hicproMatrixPath, bed = hicproBedPath, pairs = pairsPath ,
  metadata = list(type = 'example')
)
hicpro
resolution(hicpro)
pairsFile(hicpro)
metadata(hicpro)
}
\seealso{
\code{\link[=CoolFile]{CoolFile()}}, \code{\link[=HicFile]{HicFile()}}
}
