% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiCExperiment-class.R,
%   R/HiCExperiment-methods.R
\docType{class}
\name{HiCExperiment}
\alias{HiCExperiment}
\alias{HiCExperiment-class}
\alias{makeHiCExperimentFromGInteractions}
\alias{resolutions,HiCExperiment-method}
\alias{resolution,HiCExperiment-method}
\alias{focus,HiCExperiment-method}
\alias{focus<-,HiCExperiment-method}
\alias{focus<-,HiCExperiment,character-method}
\alias{zoom,HiCExperiment,numeric-method}
\alias{refocus,HiCExperiment,character-method}
\alias{scores,HiCExperiment-method}
\alias{scores,HiCExperiment,missing-method}
\alias{scores,HiCExperiment,character-method}
\alias{scores,HiCExperiment,numeric-method}
\alias{scores<-,HiCExperiment-method}
\alias{scores<-,HiCExperiment,character,numeric-method}
\alias{topologicalFeatures,HiCExperiment-method}
\alias{topologicalFeatures,HiCExperiment,missing-method}
\alias{topologicalFeatures,HiCExperiment,character-method}
\alias{topologicalFeatures,HiCExperiment,numeric-method}
\alias{topologicalFeatures<-,HiCExperiment-method}
\alias{topologicalFeatures<-,HiCExperiment,character,GRangesOrGInteractions-method}
\alias{pairsFile,HiCExperiment-method}
\alias{pairsFile<-,HiCExperiment-method}
\alias{pairsFile<-,HiCExperiment,character-method}
\alias{metadata<-,HiCExperiment-method}
\alias{metadata<-,HiCExperiment,list-method}
\alias{fileName,HiCExperiment-method}
\alias{interactions,HiCExperiment-method}
\alias{interactions<-,HiCExperiment-method}
\alias{length,HiCExperiment-method}
\alias{[,HiCExperiment-method}
\alias{[,HiCExperiment,numeric,ANY,ANY-method}
\alias{subsetByOverlaps,HiCExperiment,GRanges-method}
\alias{[,HiCExperiment,logical,ANY,ANY-method}
\alias{[,HiCExperiment,character,ANY,ANY-method}
\alias{[,HiCExperiment,GInteractions,ANY,ANY-method}
\alias{[,HiCExperiment,Pairs,ANY,ANY-method}
\alias{seqinfo,HiCExperiment-method}
\alias{bins,HiCExperiment-method}
\alias{anchors,HiCExperiment-method}
\alias{regions,HiCExperiment-method}
\alias{cis,HiCExperiment-method}
\alias{trans,HiCExperiment-method}
\alias{show,HiCExperiment-method}
\alias{subsetByOverlaps,HiCExperiment,numeric-method}
\alias{subsetByOverlaps,HiCExperiment,logical-method}
\alias{subsetByOverlaps,HiCExperiment,GInteractions-method}
\alias{subsetByOverlaps,HiCExperiment,Pairs-method}
\alias{[,HiCExperiment,GRanges,ANY,ANY-method}
\alias{interactions<-,HiCExperiment,GInteractions-method}
\alias{$<-,HiCExperiment-method}
\alias{$,HiCExperiment-method}
\title{\code{HiCExperiment} S4 class}
\usage{
HiCExperiment(
  file,
  resolution = NULL,
  focus = NULL,
  metadata = list(),
  topologicalFeatures = S4Vectors::SimpleList(compartments = GenomicRanges::GRanges(),
    borders = GenomicRanges::GRanges(), loops =
    InteractionSet::GInteractions(GenomicRanges::GRanges(), GenomicRanges::GRanges()),
    viewpoints = GenomicRanges::GRanges()),
  pairsFile = NULL,
  bed = NULL
)

makeHiCExperimentFromGInteractions(gi)

\S4method{resolutions}{HiCExperiment}(x)

\S4method{resolution}{HiCExperiment}(x)

\S4method{focus}{HiCExperiment}(x)

\S4method{focus}{HiCExperiment,character}(x) <- value

\S4method{zoom}{HiCExperiment,numeric}(x, resolution)

\S4method{refocus}{HiCExperiment,character}(x, focus)

\S4method{scores}{HiCExperiment,missing}(x)

\S4method{scores}{HiCExperiment,character}(x, name)

\S4method{scores}{HiCExperiment,numeric}(x, name)

\S4method{scores}{HiCExperiment,character,numeric}(x, name) <- value

\S4method{topologicalFeatures}{HiCExperiment,missing}(x)

\S4method{topologicalFeatures}{HiCExperiment,character}(x, name)

\S4method{topologicalFeatures}{HiCExperiment,numeric}(x, name)

\S4method{topologicalFeatures}{HiCExperiment,character,GRangesOrGInteractions}(x, name) <- value

\S4method{pairsFile}{HiCExperiment}(x)

\S4method{pairsFile}{HiCExperiment,character}(x) <- value

\S4method{metadata}{HiCExperiment,list}(x) <- value

\S4method{subsetByOverlaps}{HiCExperiment,numeric}(x, ranges)

\S4method{subsetByOverlaps}{HiCExperiment,logical}(x, ranges)

\S4method{subsetByOverlaps}{HiCExperiment,GRanges}(x, ranges, type = c("within", "any"))

\S4method{subsetByOverlaps}{HiCExperiment,GInteractions}(x, ranges)

\S4method{subsetByOverlaps}{HiCExperiment,Pairs}(x, ranges)

\S4method{[}{HiCExperiment,numeric,ANY,ANY}(x, i)

\S4method{[}{HiCExperiment,GRanges,ANY,ANY}(x, i)

\S4method{[}{HiCExperiment,logical,ANY,ANY}(x, i)

\S4method{[}{HiCExperiment,GInteractions,ANY,ANY}(x, i)

\S4method{[}{HiCExperiment,Pairs,ANY,ANY}(x, i)

\S4method{[}{HiCExperiment,character,ANY,ANY}(x, i)

\S4method{fileName}{HiCExperiment}(object)

\S4method{interactions}{HiCExperiment}(x, fillout.regions = FALSE)

\S4method{interactions}{HiCExperiment,GInteractions}(x) <- value

\S4method{length}{HiCExperiment}(x)

\S4method{$}{HiCExperiment}(x, name) <- value

\S4method{$}{HiCExperiment}(x, name)

\S4method{seqinfo}{HiCExperiment}(x)

\S4method{bins}{HiCExperiment}(x)

\S4method{anchors}{HiCExperiment}(x)

\S4method{regions}{HiCExperiment}(x)

\S4method{cis}{HiCExperiment}(x)

\S4method{trans}{HiCExperiment}(x)
}
\arguments{
\item{file}{CoolFile or plain path to a Hi-C contact file}

\item{resolution}{Resolution to use with the Hi-C contact file}

\item{focus}{Chromosome coordinates for which
interaction counts are extracted from the Hi-C contact file, provided
as a character string (e.g. "II:4001-5000"). If not provided,
the entire Hi-C contact file will be imported.}

\item{metadata}{list of metadata}

\item{topologicalFeatures}{topologicalFeatures provided as a named SimpleList}

\item{pairsFile}{Path to an associated .pairs file (optional)}

\item{bed}{Path to regions file generated by HiC-Pro (optional)}

\item{gi}{GInteractions object}

\item{x}{A \code{HiCExperiment} object.}

\item{value}{Value to add to topologicalFeatures, scores, pairsFile or metadata slots.}

\item{name}{Name of the element to access in topologicalFeatures or scores SimpleLists.}

\item{type}{any of \code{within} or \code{any}, to subset interactions by overlap with a provided GRanges.}

\item{i, ranges}{a GRanges, coordinates in character, or boolean vector to subset a HiCExperiment}

\item{object}{A \code{HiCExperiment} object.}

\item{fillout.regions}{Whehter to add missing regions to GInteractions' regions?}
}
\value{
An \code{HiCExperiment} object.
}
\description{
The \code{HiCExperiment} class describes Hi-C contact files imported in R, either
through the \code{HiCExperiment} constructor function or using the \code{import}
method implemented by \code{HiCExperiment} package.
}
\section{Slots}{

\describe{
\item{\code{fileName}}{Path of Hi-C contact file}

\item{\code{focus}}{Chr. coordinates for which interaction counts are extracted
from the Hi-C contact file.}

\item{\code{resolutions}}{Resolutions available in the Hi-C contact file.}

\item{\code{resolution}}{Current resolution}

\item{\code{interactions}}{Genomic Interactions extracted from the Hi-C contact file}

\item{\code{scores}}{Available interaction scores.}

\item{\code{topologicalFeatures}}{Topological features associated with the dataset
(e.g. loops (\<GInteractions\>), borders (\<GRanges\>),
viewpoints (\<GRanges\>), etc...)}

\item{\code{pairsFile}}{Path to the .pairs file associated with the Hi-C contact file}

\item{\code{metadata}}{metadata associated with the Hi-C contact file.}
}}

\examples{
#####################################################################
## Create a HiCExperiment object from a disk-stored contact matrix ##
#####################################################################

mcool_file <- HiContactsData::HiContactsData("yeast_wt", "mcool")
pairs_file <- HiContactsData::HiContactsData("yeast_wt", "pairs.gz")
contacts <- HiCExperiment(
    file = mcool_file, 
    resolution = 8000L, 
    pairsFile = pairs_file
)
contacts

#####################################################################
## ----- Manually create a HiCExperiment from GInteractions ------ ##
#####################################################################

gis <- interactions(contacts)[1:1000]
contacts2 <- makeHiCExperimentFromGInteractions(gis)
contacts2

#####################################################################
## -------- Slots present in an HiCExperiment object ------------- ##
#####################################################################

fileName(contacts)
focus(contacts)
resolutions(contacts)
resolution(contacts)
interactions(contacts)
scores(contacts)
topologicalFeatures(contacts)
pairsFile(contacts)

#####################################################################
## ---------------------- Slot getters --------------------------- ##
#####################################################################

scores(contacts, 1) |> head()
scores(contacts, 'balanced') |> head()
topologicalFeatures(contacts, 1)

#####################################################################
## ---------------------- Slot setters --------------------------- ##
#####################################################################

scores(contacts, 'random') <- runif(length(contacts))
topologicalFeatures(contacts, 'loops') <- InteractionSet::GInteractions(
  GenomicRanges::GRanges('II:15324'), 
  GenomicRanges::GRanges('II:24310')
)
pairsFile(contacts) <- HiContactsData('yeast_wt', 'pairs.gz')

#####################################################################
## ------------------ Subsetting functions ----------------------- ##
#####################################################################

contacts[1:100]
contacts['II']
contacts[c('II', 'III')]
contacts['II|III']
contacts['II:10001-30000|III:50001-90000']

#####################################################################
## --------------------- Utils functions ------------------------- ##
#####################################################################
## Adapted from other packages

seqinfo(contacts)
bins(contacts)
anchors(contacts)
regions(contacts)

#####################################################################
## ------------- Coercing HiCExperiment objects ------------------ ##
#####################################################################

as(contacts, 'GInteractions')
as(contacts, 'ContactMatrix')
as(contacts, 'matrix')[seq_len(10), seq_len(10)]
as(contacts, 'data.frame')[seq_len(10), seq_len(10)]
}
\seealso{
\code{\link[=AggrHiCExperiment]{AggrHiCExperiment()}}, \code{\link[=CoolFile]{CoolFile()}}, \code{\link[=HicFile]{HicFile()}}, \code{\link[=HicproFile]{HicproFile()}}, \code{\link[=PairsFile]{PairsFile()}}
}
