% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSparseReplicates.R
\name{filterSparseReplicates}
\alias{filterSparseReplicates}
\title{Filter sparse replicates.}
\usage{
filterSparseReplicates(object, threshold = NULL)
}
\arguments{
\item{object}{A \code{\link{HiCDOCDataSet}}.}

\item{threshold}{The minimum percentage of non-zero interactions for a chromosome replicate to
be kept. If a chromosome replicate's percentage of non-zero interactions is
lower than this value, it is removed. Defaults to
\code{object$smallChromosomeThreshold} which is originally set to
\code{defaultHiCDOCParameters$smallChromosomeThreshold = 30\%}.}
}
\value{
A filtered \code{\link{HiCDOCDataSet}}.
}
\description{
Removes chromosome replicates whose percentage of non-zero interactions is
smaller than the threshold.
}
\examples{
data(exampleHiCDOCDataSet)
object <- exampleHiCDOCDataSet

object <- filterSparseReplicates(object)

}
\seealso{
\code{\link{filterSmallChromosomes}},
\code{\link{filterWeakPositions}},
\code{\link{HiCDOC}}
}
