% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{HiCDOCDataSetFromHiCPro}
\alias{HiCDOCDataSetFromHiCPro}
\title{\code{\link{HiCDOCDataSet}} constructor from HiC-Pro files.}
\usage{
HiCDOCDataSetFromHiCPro(matrixPaths, bedPaths, replicates, conditions)
}
\arguments{
\item{matrixPaths}{A vector of paths to HiC-Pro matrix files.}

\item{bedPaths}{A vector of paths to HiC-Pro bed files.}

\item{replicates}{A vector of replicate names repeated along the conditions.}

\item{conditions}{A vector of condition names repeated along the replicates.}
}
\value{
A \code{\link{HiCDOCDataSet}}.
}
\description{
Constructs a \code{\link{HiCDOCDataSet}} from a set of HiC-Pro generated
files.
}
\examples{
\dontrun{
    # Path to each matrix file
    matrixPaths = c(
      'path/to/condition-1.replicate-1.matrix',
      'path/to/condition-1.replicate-2.matrix',
      'path/to/condition-2.replicate-1.matrix',
      'path/to/condition-2.replicate-2.matrix',
      'path/to/condition-3.replicate-1.matrix'
    )

    # Path to each bed file
    bedPaths = c(
      'path/to/condition-1.replicate-1.bed',
      'path/to/condition-1.replicate-2.bed',
      'path/to/condition-2.replicate-1.bed',
      'path/to/condition-2.replicate-2.bed',
      'path/to/condition-3.replicate-1.bed'
    )

    # Replicate and condition of each file. Can be names instead of numbers.
    replicates <- c(1, 2, 1, 2, 1)
    conditions <- c(1, 1, 2, 2, 3)

    # Instantiation of data set
    hic.experiment <- HiCDOCDataSetFromHiCPro(
      matrixPaths = matrixPaths,
      bedPaths = bedPaths,
      replicates = replicates,
      conditions = conditions
    )
}

}
