% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{HiCDOCDataSet-methods}
\alias{HiCDOCDataSet-methods}
\alias{chromosomes}
\alias{sampleConditions}
\alias{sampleReplicates}
\alias{compartments}
\alias{differences}
\alias{concordances}
\alias{chromosomes,HiCDOCDataSet-method}
\alias{sampleConditions,HiCDOCDataSet-method}
\alias{sampleReplicates,HiCDOCDataSet-method}
\alias{compartments,HiCDOCDataSet-method}
\alias{differences,HiCDOCDataSet-method}
\alias{concordances,HiCDOCDataSet-method}
\alias{show,HiCDOCDataSet-method}
\title{Methods to access a \code{\link{HiCDOCDataSet}} components.}
\usage{
\S4method{chromosomes}{HiCDOCDataSet}(object)

\S4method{sampleConditions}{HiCDOCDataSet}(object)

\S4method{sampleReplicates}{HiCDOCDataSet}(object)

\S4method{compartments}{HiCDOCDataSet}(object, passChecks = TRUE)

\S4method{differences}{HiCDOCDataSet}(object, threshold = NULL)

\S4method{concordances}{HiCDOCDataSet}(object, passChecks = TRUE)

\S4method{show}{HiCDOCDataSet}(object)
}
\arguments{
\item{object}{a HiCDOCDataSet object}

\item{passChecks}{logical. Display only the concordances/compartments for 
the chromosomes passing sanity checks.}

\item{threshold}{a numeric value between 0 and 1. If no threshold, all the differences will
be printed even the non significant ones. Otherwise the differences printed
are filtered to show the ones with an adjusted p-value <= \code{threshold}.}
}
\value{
A character vector (for \code{chromosomes}, \code{sampleConditions},
\code{sampleReplicates}), 
or a GRanges object
(for \code{compartments}, \code{concordances}, \code{differences}).
}
\description{
Retrieve information and results from a \code{\link{HiCDOCDataSet}}.
}
\section{Functions}{
\itemize{
\item \code{chromosomes()}: Retrieves the vector of chromosome names.

\item \code{sampleConditions()}: Retrieves the vector of condition names, one for each sample.

\item \code{sampleReplicates()}: Retrieves the vector of replicate names, one for each sample.

\item \code{compartments()}: Retrieves a \code{GenomicRange} of the compartment of every position
in every condition.

\item \code{differences()}: Retrieves a \code{GenomicRange} of the significant compartment differences
between conditions, and their p-values.

\item \code{concordances()}: Retrieves a \code{GenomicRange} of the concordance (confidence in assigned
compartment) of every position in every replicate.

}}
\examples{
# Load an example dataset already processed 
# (i.e. after the detection of compartments)
data(exampleHiCDOCDataSetProcessed)

exampleHiCDOCDataSetProcessed
chromosomes(exampleHiCDOCDataSetProcessed)
sampleConditions(exampleHiCDOCDataSetProcessed)
sampleReplicates(exampleHiCDOCDataSetProcessed)
compartments(exampleHiCDOCDataSetProcessed)
differences(exampleHiCDOCDataSetProcessed)
concordances(exampleHiCDOCDataSetProcessed)

}
