% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{HiCDOC}
\alias{HiCDOC}
\title{Default pipeline to run on the HiCDOC analysis.}
\usage{
HiCDOC(object, parallel = FALSE)
}
\arguments{
\item{object}{A \code{HiCDOCDataSet}.}

\item{parallel}{Whether or not to parallelize each step. Defaults to FALSE.}
}
\value{
A HiCDOCDataSet with all slots filled.
}
\description{
Runs the default filtering, normalization, and computational steps on a
\code{HiCDOCDataSet}. To learn more about HiCDOC, browse the vignette:
\code{browseVignettes(package = "HiCDOC")}.
}
\details{
\subsection{\code{HiCDOC} pipeline}{
    The HiCDOC pipeline has seven steps: \\
    \describe{
        Three filtering steps:
        \itemize{
            \item{\code{\link{filterSmallChromosomes}}} to filter out 
            small chromosomes
            \item{\code{\link{filterWeakPositions}}} to filter out weak 
            positions with very few interactions
            \item{\code{\link{filterSparseReplicates}}} to filter out 
            sparse replicates with many null interactions
        }
        Three normalization steps:
        \itemize{
            \item{\code{\link{normalizeTechnicalBiases}}} to normalize 
            technical biases in each replicates
            \item{\code{\link{normalizeBiologicalBiases}}} to normalize 
            biological biases in each replicate
            \item{\code{\link{normalizeDistanceEffect}}} to normalize the 
            distance effect in each chromosome
        }
        One computational step:
        \itemize{
            \item{\code{\link{detectCompartments}}} to detect compartments 
            in each condition and find significant changes between 
            conditions.
        }
    }
}
\subsection{Parallel processing}{
The parallel version of HiCDOC uses the
\code{\link{BiocParallel}} package. Before to call the
function in parallel you should specify the parallel parameters such as:
    \itemize{
        \item{On Linux:}
           \code{multiParam <- BiocParallel::MulticoreParam(workers = 10)}
         \item{On Windows:}
             \code{multiParam <- BiocParallel::SnowParam(workers = 10)}
    }
    And then you can register the parameters to be used by BiocParallel: \\
    \code{BiocParallel::register(multiParam, default = TRUE)}

    You should be aware that using MulticoreParam, reproducibility of the
    detectCompartments function using a RNGseed may not work. See this
    \href{https://github.com/Bioconductor/BiocParallel/issues/122}{issue}
    for more details.
}
}
\examples{
data(exampleHiCDOCDataSet)
# Default HiCDOC pipeline
# Not printing loess warnings for example purpose. 
# Results should be inspected if there is any.
suppressWarnings(
object <- HiCDOC(exampleHiCDOCDataSet)
)

# Equivalent to
if(FALSE){
    object <- filterSmallChromosomes(exampleHiCDOCDataSet)
    object <- filterSparseReplicates(object)
    object <- filterWeakPositions(object)
    object <- normalizeTechnicalBiases(object)
    object <- normalizeBiologicalBiases(object)
    object <- normalizeDistanceEffect(object)
    object <- detectCompartments(object)
}

}
\seealso{
\code{\link{HiCDOCDataSet}}, \code{\link{filterSmallChromosomes}},
\code{\link{filterWeakPositions}}, \code{\link{filterSparseReplicates}},
\code{\link{normalizeTechnicalBiases}},
\code{\link{normalizeBiologicalBiases}},
\code{\link{normalizeDistanceEffect}},
\code{\link{detectCompartments}}
}
