% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_list_topdom.R
\name{gi_list_topdom}
\alias{gi_list_topdom}
\title{gi_list_topdom}
\usage{
gi_list_topdom(
  gi_list,
  chrs = NULL,
  file_out = FALSE,
  fpath = NULL,
  window.size = 5,
  verbose = FALSE
)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects where each object
named with chromosomes contains intrachromosomal interaction information
(see
\code{?gi_list_validate} for a detailed explanation of valid \code{gi_list}
instances).}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to chromosomes in \code{gi_list}.}

\item{file_out}{If true, outputs TAD annotations into files with paths
beginning with \code{fpath}. Defaults to FALSE}

\item{fpath}{Outputs TAD annotations into files with paths beginning
in \code{fpath}.}

\item{window.size}{integer, number of bins to extend. Defaults to 5.}

\item{verbose}{TRUE if you would like to troubleshoot TopDom.}
}
\value{
a list instance with TAD annotation reporting for each chromosome
}
\description{
This function converts a gi_list instance with ICE normalized counts
into TAD annotations through an implementation of TopDom v0.0.2
(https://github.com/HenrikBengtsson/TopDom) adapted as 
\code{TopDom} at this package. If you're using this function, please cite 
TopDom according to the documentation at 
https://github.com/HenrikBengtsson/TopDom/blob/0.0.2/docs/
}
\examples{
hic_path<-system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus")
gi_list<-hic2icenorm_gi_list(hic_path,binsize=50e3,chrs='chr22')
tads<-gi_list_topdom(gi_list)
}
