% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_enzyme_cutsites.R
\name{get_enzyme_cutsites}
\alias{get_enzyme_cutsites}
\title{get_enzyme_cutsites}
\usage{
get_enzyme_cutsites(sig, gen = "Hsapiens", gen_ver = "hg19", chrs = NULL)
}
\arguments{
\item{sig}{a set of restriction enzyme cut patterns (e.g.,
'GATC' or c('GATC','GANTC'))}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}}

\item{chrs}{a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes (except Y and M)
in the genome specified by \code{gen} and \code{gen_ver}.}
}
\value{
list of chromosomes.
}
\description{
This function finds all restriction enzyme cutsites of a given genome,
genome version, and set of cut patterns
}
\examples{
get_enzyme_cutsites(gen='Hsapiens',gen_ver='hg19',
sig=c('GATC','GANTC'),chrs=c('chr22'))
}
