% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hic_eigenvectors.R
\name{extract_hic_eigenvectors}
\alias{extract_hic_eigenvectors}
\title{extract_hic_eigenvectors}
\usage{
extract_hic_eigenvectors(
  hicfile,
  mode = "KR",
  binsize = 250e3,
  chrs = NULL,
  gen = "Hsapiens",
  gen_ver = "hg19"
)
}
\arguments{
\item{hicfile}{path to the input .hic file.}

\item{mode}{Normalization mode to extract first eigenvectors from 
Allowable options are: 'NONE' for raw (normalized counts if .hic file is 
written using \code{hicdc2hic} or \code{hic2icenorm_gi_list}), 'KR' for
Knight-Ruiz normalization, 'VC' for Vanilla-Coverage normalization and
'VC_SQRT' for square root vanilla coverage. Defaults to 'KR'.}

\item{binsize}{the uniform binning size for compartment scores in bp.
Defaults to 100e3.}

\item{chrs}{a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes except "Y", and "M" for
the specified \code{gen} and \code{gen_ver}.}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}.}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}.}
}
\value{
path to the eigenvector text files for each chromosome containing
chromosome, start, end
and compartment score values that may need to be flipped signs for each
chromosome. File paths 
follow \code{gsub('.hic','_<chromosome>_eigenvectors.txt',hicfile)}
}
\description{
This function uses Juicer command line tools to extract first eigenvectors
across chromosomes from counts data in a .hic file and outputs them to text 
file of the structure chr start end score where the score column contains 
the eigenvector elements.
}
\examples{
eigenvector_filepaths<-extract_hic_eigenvectors(
hicfile=system.file("extdata", "eigenvector_example.hic",
package = "HiCDCPlus"),
chrs=c("chr22"),binsize=250e3,mode="NONE")
}
