% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_values_by_distance}
\alias{Brick_get_values_by_distance}
\title{Return values separated by a certain distance.}
\usage{
Brick_get_values_by_distance(
    Brick,
    chr,
    distance,
    resolution,
    constrain_region = NULL,
    batch_size = 500,
    FUN = NULL
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{chr}{\strong{Required}.
A string specifying the chromosome for the cis Hi-C matrix from which values
will be retrieved at a certain distance.}

\item{distance}{\strong{Required}. 0 based.
Fetch values separated by distance.}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{constrain_region}{\strong{Optional}.
A character vector of length 1 with the form chr:start:end specifying the
region for which the distance values must be retrieved.}

\item{batch_size}{\strong{Optional}. Default 500
A numeric vector of length 1 specifying the size of the chunk to retrieve
for diagonal selection.}

\item{FUN}{\strong{Optional}.
If provided a data transformation with FUN will be applied before values
are returned.}
}
\value{
Returns a numeric vector of length N depending on the presence of
constrain_region, FUN and distance from the main diagonal.
}
\description{
\code{Brick_get_values_by_distance} can fetch values with or without
transformation or subsetted by a certain distance. Please note,
this module is not an iterable module.
}
\examples{
Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "val_by_dist_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Brick_get_values_by_distance(Brick = My_BrickContainer, chr = "chr2L",
distance = 0, resolution = 100000)

Failsafe_median <- function(x){
     x[is.nan(x) | is.infinite(x) | is.na(x)] <- 0
     return(median(x))
}

Brick_get_values_by_distance(Brick = My_BrickContainer, chr = "chr2L", 
resolution = 100000, distance = 4, FUN = Failsafe_median)

}
\seealso{
\code{\link{Brick_get_matrix_within_coords}} to get matrix by
using matrix coordinates, \code{\link{Brick_fetch_row_vector}} to get values
in a certain row/col and subset them, \code{\link{Brick_get_vector_values}}
to get values using matrix coordinates, \code{\link{Brick_get_matrix}} to
get matrix by using matrix coordinates.
}
