% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{install_CondaTools}
\alias{install_CondaTools}
\title{Install Conda requirements.}
\usage{
install_CondaTools(
  tools,
  env,
  channels = NULL,
  pathToMiniConda = NULL,
  updateEnv = FALSE,
  search = FALSE,
  verbose = FALSE,
  mamba = FALSE
)
}
\arguments{
\item{tools}{Vector of software to install using conda.}

\item{env}{Name of Conda environment to install tools into.}

\item{channels}{Channels for miniconda (bioconda and conda-forge are defaults).}

\item{pathToMiniConda}{NULL Path to miniconda installation}

\item{updateEnv}{Update existing package's conda environment if already installed.}

\item{search}{Whether to search for the package name and version before installing. It is highly recommended this be set to TRUE as information about available versions or similar packages will be included in the output if the exact match is not found.}

\item{verbose}{Print system messages from conda on progress (Default is FALSE). There is a third option "silent" which suppresses Herper and Conda messaging.}

\item{mamba}{A logical about whether to use the mamba solver to speed up the resolution of environment dependencies (Default is FALSE).}
}
\value{
Nothing returned. Output written to file.
}
\description{
Install Conda requirements
}
\details{
This function will install conda software.
For a more detailed walkthrough check our webpage: https://rockefelleruniversity.github.io/Herper_Page/
}
\author{
Thomas Carroll and Matt Paul
}
