\name{greyList}
\docType{data}
\alias{greyList}
\title{A sample \code{\linkS4class{GreyList}} object for use in examples.}
\description{This is a sample \code{\linkS4class{GreyList}} object, covering
only human chromosome 21 (from genome version hg19).  The input library
used to generate this grey list can be found in the European Nucleotide
Archive, under accession number ERR336953.

The library was made from a culture of the MCF-7 cell line, bought from ATCC.
The library was sequenced to a depth of 35,716,191 reads on an Illumina
Genome Analyzer IIx.  The reads were aligned to human reference genome hg19
(GRCh37) using BWA version 0.7.5a with default parameters.  Approximately
96\% of reads aligned to the reference genome.
Reads aligning to chromosome 21 were extracted using \code{Samtools}.
The chromosome 21-only karyotype file was created by deleting all lines
except chromosome 21, in a file generated by \code{fetchChromSizes} as
described in the vignette.  This package was then used to create the
\code{\linkS4class{GreyList}} sample object.

When printed, the object displays several important slots in the object (if
they have been filled with calculated values).
For example, this object has all its slots filled, indicating that the
analysis is complete:

\preformatted{   GreyList on karyotype file karyotype_chr21.txt
     tiles: 94004
     files: jc899_chr21.bam
     size (mean): 0.370332362145541
     mu (mean): 10.2330008719269
     params: reps=10, sample size=1000, p-value=0.99
     threshold: 81
     regions: 118
     coverage: 4.45\%
}

The fields are described in the class's documentation, but briefly, we can see:
\enumerate{
  \item the name of the karyotype file (or \code{BSgenome} object),
  \item the number of tiles (overlapping by 1/2 the tile width),
  \item the BAM file(s) used for read counting (currently only 1 is allowed),
  \item the two estimated parameters of the negative binomial distribution,
        \code{size} and \code{mu},
  \item the input parameters,
  \item the calculated read depth cutoff (over 1kb tiles),
  \item the number of distinct regions, and
  \item the percentage coverage of the reference genome.
}

The fact that all the fields are present indicates that the regions have been
generated; otherwise fields still without values would be omitted.  Of course
any stage can be re-run with different parameters.
}
\usage{data(greyList)}
\value{A \code{\linkS4class{GreyList}} object named \code{greyList}.}
\format{An S4 \code{\linkS4class{GreyList}} object.}
\keyword{datasets}
