% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn_tabu_gen_1.R
\name{InverseARCs}
\alias{InverseARCs}
\title{Identifies arcs between nodes with inverse relationships}
\usage{
InverseARCs(Output, threshold = -0.3)
}
\arguments{
\item{Output}{a data frame containing the output of 
BN_Conditions function.}

\item{threshold}{number indicating the maximum slope for 
defining negative 
relationships.
Default level is -0.3.}
}
\value{
arcs with inverse relationships
}
\description{
Identifies arcs between nodes with inverse relationships
}
\examples{
GMIC_net_dir<-system.file("extdata", "GMIC_net.Rdata", 
package = "GmicR", mustWork = TRUE)
load(GMIC_net_dir)
GMIC_Final<-InverseARCs(GMIC_net, threshold = -0.3)
}
