% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCI.R
\name{plotCI}
\alias{plotCI}
\title{Plot confidence intervals}
\usage{
plotCI(ci_df, color_by, group_by, dodge_width = 0.5)
}
\arguments{
\item{ci_df}{A data frame contains each sample's metadata. Note this is
NOT at the cell-level.}

\item{color_by}{The column name or index in ci_df that should be used
to color the confidence intervals by.}

\item{group_by}{The column name or index in ci_df that should be used to
determine how to group the confidence intervals. If missing all confidence
intervals will be plotted in an order determined internally.}

\item{dodge_width}{value passed to `width` argument of
\code{\link[ggplot2]{position_dodge}} if `group_by` variable is given.
Controls separation between confidence intervals with the same grouping
value.}
}
\value{
A plot of sample-pair divergences with confidence intervals
}
\description{
This function creates a `ggplot` object that plots the
  confidence intervals created by `bootCI`
}
\examples{
data(example_SCE_small)
sample_ids <- SingleCellExperiment::colData(example_SCE_small)$sample_id
# Run gloscope on first 10 PCA embeddings
# We use 'KNN' option for speed ('GMM' is slightly slower)
pca_embeddings <- SingleCellExperiment::reducedDim(example_SCE_small,"PCA")
pca_embeddings_subset <- pca_embeddings[,seq_len(10)] # select the first 10 PCs
dist_result <- gloscope(pca_embeddings_subset, sample_ids,
   dens="KNN",
   BPPARAM = BiocParallel::SerialParam(RNGseed=2))
# make a per-sample metadata
sample_metadata <- as.data.frame(unique(SingleCellExperiment::colData(example_SCE_small)[,c(1,2)]))
# make another variable
sample_metadata$fakeGroup<-c(rep(c("A","B"),each=2),"A")
manyboot<-bootCI(dist_result,
  sample_metadata,"sample_id",
  metrics=c("anosim","silhouette"),group_vars=c("phenotype","fakeGroup"),R=20)
plotCI(manyboot,group_by="metric",color_by="grouping")

}
