% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-qc.R
\name{setBackgroundQCFlags}
\alias{setBackgroundQCFlags}
\title{Add background QC flags to NanoStringGeoMxSet object protocol data}
\usage{
setBackgroundQCFlags(object, qcCutoffs = DEFAULTS)
}
\arguments{
\item{object}{name of the NanoStringGeoMxSet object to perform QC on}

\item{qcCutoffs}{a list of qc cutoffs to use
\enumerate{
    \item{minNegativeCount, 
          numeric to flag segments with less than this number of counts}
    \item{maxNTCCount, 
          numeric to flag segments with more than this number of NTC counts}
}}
}
\value{
\code{NanoStringGeoMxSet} object with \code{QCFlags} data frame 
            appended to \code{protocolData}
}
\description{
Add background QC flags to NanoStringGeoMxSet object protocol data
}
\examples{
datadir <- system.file("extdata", "DSP_NGS_Example_Data",
                       package="GeomxTools")
demoData <- readRDS(file.path(datadir, "/demoData.rds"))
setBackgroundQCFlags(demoData[,1:10], 
                 qcCutoffs=list(minNegativeCount=10, 
                                maxNTCCount=60))

}
