% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoisBG.R
\docType{methods}
\name{fitPoisBG}
\alias{fitPoisBG}
\alias{fitPoisBG,NanoStringGeoMxSet-method}
\alias{fitPoisBG,matrix-method}
\title{Estimate Poisson background model for either single slide or multiple slides}
\usage{
fitPoisBG(object, ...)

\S4method{fitPoisBG}{NanoStringGeoMxSet}(
  object,
  groupvar = NULL,
  iterations = 10,
  tol = 0.001,
  size_scale = c("sum", "first"),
  ...
)

\S4method{fitPoisBG}{matrix}(object, iterations = 10, tol = 0.001, size_scale = c("sum", "first"))
}
\arguments{
\item{object}{count matrix with features in rows and samples in columns}

\item{...}{additional argument list that might be used}

\item{groupvar}{the group variable name for slide}

\item{iterations}{maximum iterations to be run, default=10}

\item{tol}{tolerance to determine convergence, default = 1e-3}

\item{size_scale}{method to scale the sizefact, sum(sizefact)=1 when size_scale="sum", sizefact[1]=1 when size_scale="first"}
}
\value{
a valid GeoMx S4 object if split is FALSE
\itemize{
  \item sizefact - estimated size factor in phenoData
  \item featfact - estimated feature factor in featureData
}

a valid GeoMx S4 object if split is TRUE,
\itemize{
  \item sizefact - estimated size factor in phenoData
  \item featfact_XX - estimated feature factor vector, column name (denoted as XX) the same as the slide id, in featureData for each unique slide
  \item fitPoisBG_sp_var - the column name for slide, in experimentData
}

a list of following items
\itemize{
  \item sizefact - estimated size factor
  \item featfact - estimated feature factor
  \item countmat - the input count matrix
}
}
\description{
Estimate Poisson background model for either single slide or multiple slides

Estimate Poisson background model:
}
\examples{

data(demoData)
demoData <- fitPoisBG(demoData, size_scale = "sum")
data(demoData)
demoData <- fitPoisBG(demoData, groupvar = "slide name", size_scale = "sum")
}
