# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' An internal function to compute the IPD of a GTuples; ; only used for 
#' tuples of size > 2.
#' 
#' @param pos1 An integer vector.
#' @param internal_pos An integer matrix.
#' @param posm An integer vector.
#' 
#' @keywords internal
#'
#' @return An integer matrix with the same number of rows as internal_pos and 
#' number of columns equal to size - 1.
#' 
#' @note This function silently coerces numeric matrices to integer matrices
#' and does integer subtraction. \emph{This will give unexpected results but
#' it's not a problem for me since I only use it on integer matrices.}
.IPDCpp <- function(pos1, internal_pos, posm) {
    .Call(`_GenomicTuples_IPD`, pos1, internal_pos, posm)
}

#' An internal helper function to check that each tuple is sorted in 
#' increasing order; only used for tuples of size > 2.
#' 
#' @param pos1 An integer vector.
#' @param internal_pos An integer matrix.
#' @param posm An integer vector.
#' 
#' @keywords internal
#' 
#' @return TRUE if each tuple is sorted in strictly increasing order, 
#' FALSE otherwise.
#' 
#' @details 
#' .allTuplesSorted is adapted from http://stackoverflow.com/a/7601857.
#' Strict inequalities are required.
#' 
#' @keywords internal
#' 
.allTuplesSortedCpp <- function(pos1, internal_pos, posm) {
    .Call(`_GenomicTuples_allTuplesSorted`, pos1, internal_pos, posm)
}

#' An internal function used to pcompare GTuples.
#' 
#' @details 
#' The tuples should have already been converted to integer representations,
#' namely an integer vector for the difference in chromosome, an integer 
#' vector for the difference in strand and an integer matrix for the 
#' difference in  positions.
#' 
#' @param int_seqnames An integer vector of length n. An integer 
#' representation of the difference in seqnames of each tuple.
#' @param int_strand An integer vector of length n. An integer representation 
#' of the difference in strand of each tuple.
#' @param int_pos An integer matrix with n rows. Each row represents the 
#' difference in positions of each tuple. 
#' 
#' @return An integer vector where each element is the comparison of a pair
#' of tuples. If the first tuple in the pair is "<" than the second tuple then 
#' the return value for that element is < 0, if the first tuple in the pair is 
#' "==" the second tuple then the return value is 0, and if the first tuple is 
#' ">" that the second tuple then the return value is > 0.
#' 
#' @keywords internal
#'
#' 
.pcompareGTuplesCpp <- function(int_seqnames, int_strand, int_pos) {
    .Call(`_GenomicTuples_pcompareGTuples`, int_seqnames, int_strand, int_pos)
}

