% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_peak_annotation.R
\name{plot_peak_annotation}
\alias{plot_peak_annotation}
\title{Annotate peaks with genomic features and genes}
\usage{
plot_peak_annotation(
  peakFile,
  gtfFile,
  importParams = NULL,
  fiveP = -1000,
  dsTSS = 300,
  threeP = 1000,
  simple = FALSE,
  outPrefix = NULL,
  verbose = FALSE,
  hw = c(8, 8),
  nc = 2
)
}
\arguments{
\item{peakFile}{a string denoting the peak file name, only .bed format is
allowed}

\item{gtfFile}{path to a gene annotation gtf file with gene_biotype field}

\item{importParams}{a list of parameters for \code{handle_input}}

\item{fiveP}{extension out of the 5' boundary of genes for defining promoter:
fiveP TSS + dsTSS}

\item{dsTSS}{extension downstream of TSS for defining promoter: fiveP TSS +
dsTSS}

\item{threeP}{extension out of the 3' boundary of genes for defining
termination region: -0 TTS + threeP}

\item{simple}{logical, indicating whether 5'UTR, CDS and 3'UTR are annotated
in the gtfFile}

\item{outPrefix}{a string denoting output file name in pdf format}

\item{verbose, }{logical, to indicate whether to write the annotation results
to a file}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{nc}{number of cores for parallel processing}
}
\value{
a list of three dataframes, 'annotation' is the annotation of peaks
 into gene types, 'stat' is the summary stats for pie chart, 'simplified' is
 the summary stats excluding intron
}
\description{
Produce a table of transcripts targeted by peaks, and generate
plots for target gene types, and peak distribution in genomic features
}
\examples{

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

centerFile <- system.file("extdata", "test_chip_peak_chr19.bed",
    package = "GenomicPlot"
)
names(centerFile) <- c("summitPeak")

bedimportParams <- setImportParams(
    offset = 0, fix_width = 100, fix_point = "center", norm = FALSE,
    useScore = FALSE, outRle = FALSE, useSizeFactor = FALSE, genome = "hg19"
)

plot_peak_annotation(
    peakFile = centerFile, gtfFile = gtfFile, importParams = bedimportParams,
    fiveP = -2000, dsTSS = 200, threeP = 2000, simple = FALSE
)

}
\author{
Shuye Pu
}
