% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_locus.R
\name{plot_locus}
\alias{plot_locus}
\title{Plot signal around custom genomic loci}
\usage{
plot_locus(
  queryFiles,
  centerFiles,
  txdb = NULL,
  ext = c(-100, 100),
  hl = c(0, 0),
  shade = TRUE,
  smooth = FALSE,
  importParams = NULL,
  verbose = FALSE,
  binSize = 10,
  refPoint = "center",
  Xlab = "Center",
  Ylab = "Coverage/base/gene",
  inputFiles = NULL,
  stranded = TRUE,
  heatmap = TRUE,
  scale = FALSE,
  outPrefix = NULL,
  rmOutlier = 0,
  transform = NA,
  statsMethod = "wilcox.test",
  heatRange = NULL,
  hw = c(8, 8),
  nc = 2
)
}
\arguments{
\item{queryFiles}{a vector of sample file names. The file should be in .bam,
.bed, .wig or .bw format, mixture of formats is allowed}

\item{centerFiles}{a named vector of reference file names or genomic features
in  c("utr3", "utr5", "cds", "intron", "exon", "transcript", "gene"). The
file should be in .bed format only}

\item{txdb}{a TxDb object defined in the GenomicFeatures package. Default
NULL, needed only when genomic features are used as centerFiles.}

\item{ext}{a vector of two integers defining upstream and downstream
boundaries of the plot window, flanking the reference locus}

\item{hl}{a vector of two integers defining upstream and downstream
boundaries of the highlight window, flanking the reference locus}

\item{shade}{logical indicating whether to place a shaded rectangle around
the point of interest}

\item{smooth}{logical, indicating whether the line should smoothed with a
spline smoothing algorithm}

\item{importParams}{a list of parameters for \code{\link{handle_input}}}

\item{verbose}{logical, indicating whether to output additional information
(data used for plotting or statistical test results)}

\item{binSize}{an integer defines bin size for intensity calculation}

\item{refPoint}{a string in c("start", "center", "end")}

\item{Xlab}{a string denotes the label on x-axis}

\item{Ylab}{a string for y-axis label}

\item{inputFiles}{a vector of input sample file names. The file should be in
.bam, .bed, .wig or .bw format, mixture of formats is allowed}

\item{stranded}{logical, indicating whether the strand of the feature should
be considered}

\item{heatmap}{logical, indicating whether a heatmap of the score matrix
should be generated}

\item{scale}{logical, indicating whether the score matrix should be scaled to
the range 0:1, so that samples with different baseline can be compared}

\item{outPrefix}{a string specifying output file prefix for plots
(outPrefix.pdf)}

\item{rmOutlier}{a numeric value serving as a multiplier of the MAD in
Hampel filter for outliers identification, 0 indicating not removing
outliers. For Gaussian distribution, use 3, adjust based on data
distribution.}

\item{transform}{a string in c("log", "log2", "log10"), default = NA
indicating no transformation of data matrix}

\item{statsMethod}{a string in c("wilcox.test", "t.test"), for pair-wise
group comparisons}

\item{heatRange}{a numeric vector with three elements, defining custom range for
color ramp, default=NULL, i.e. the range is defined automatically based on
the c(minimun, median, maximum) of a data matrix}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{nc}{integer, number of cores for parallel processing}
}
\value{
a list of two dataframes containing the data used for plotting and
 for statistical testing
}
\description{
Plot reads or peak Coverage/base/gene of samples given in the
query files around reference locus (start, end or center of a genomic region)
defined in the centerFiles. The upstream and downstream windows flanking loci
can be given separately, a smaller window can be defined to allow statistical
comparisons between samples for the same reference, or between references for
a given sample. If Input files are provided, ratio over Input is computed and
displayed as well.
}
\examples{
centerfiles <- c(
system.file("extdata", "test_clip_peak_chr19.bed", package = "GenomicPlot"),
system.file("extdata", "test_chip_peak_chr19.bed", package = "GenomicPlot"))

names(centerfiles) <- c("iCLIPPeak", "SummitPeak")
queryfiles <- c(
    system.file("extdata", "chip_treat_chr19.bam", package = "GenomicPlot"))

names(queryfiles) <- c("chip_bam")
inputfiles <- c(
    system.file("extdata", "chip_input_chr19.bam", package = "GenomicPlot"))
names(inputfiles) <- c("chip_input")

chipimportParams <- setImportParams(
    offset = 0, fix_width = 150, fix_point = "start", norm = TRUE,
    useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

plot_locus(
  queryFiles = queryfiles,
  centerFiles = centerfiles,
  ext = c(-500, 500),
  hl = c(-100, 100),
  shade = TRUE,
  smooth = TRUE,
  importParams = chipimportParams,
  binSize = 10,
  refPoint = "center",
  Xlab = "Center",
  inputFiles = inputfiles,
  stranded = TRUE,
  scale = FALSE,
  outPrefix = NULL,
  verbose = FALSE,
  transform = NA,
  rmOutlier = 0,
  Ylab = "Coverage/base/peak",
  statsMethod = "wilcox.test",
  heatmap = TRUE,
  nc = 2
)


}
\author{
Shuye Pu
}
