% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleFeatures.R
\name{get_txdb_features}
\alias{get_txdb_features}
\title{Get genomic coordinates of features of protein-coding genes}
\usage{
get_txdb_features(txdb, fiveP = -1000, dsTSS = 300, threeP = 1000, nc = 2)
}
\arguments{
\item{txdb}{a TxDb object defined in the GenomicFeatures package}

\item{fiveP}{extension upstream of the 5' boundary of genes}

\item{dsTSS}{range of promoter extending downstream of TSS}

\item{threeP}{extension downstream of the 3' boundary of genes}

\item{nc}{number of cores for parallel processing}
}
\value{
a GRangesList object
}
\description{
Get genomic coordinates of promoter, 5'UTR, CDS, 3'UTR, TTS and
intron for the longest transcript of protein-coding genes. The range of
promoter is defined by fiveP and dsTSS upstream and downstream TSS,
respectively, the TTS ranges from the 3' end of the gene to threeP
downstream, or the start of a downstream gene, whichever is closer.
}
\examples{
gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

txdb <- custom_TxDb_from_GTF(gtfFile, genome = "hg19")

f <- get_txdb_features(txdb, dsTSS = 100, fiveP = -100, threeP = 100)

}
\author{
Shuye Pu
}
