% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_annotations.r
\docType{methods}
\name{summariseByFeaturePairs}
\alias{summariseByFeaturePairs}
\alias{summariseByFeaturePairs,GInteractions-method}
\title{Summarise the number of interactions between two sets of features.}
\usage{
summariseByFeaturePairs(
  GIObject,
  features.one,
  feature.name.one,
  features.two,
  feature.name.two
)

\S4method{summariseByFeaturePairs}{GInteractions}(
  GIObject,
  features.one,
  feature.name.one,
  features.two,
  feature.name.two
)
}
\arguments{
\item{GIObject}{An annotated GInteractions object}

\item{features.one}{A GRanges object containing the feature set of interest}

\item{feature.name.one}{The name of the first feature set of interest}

\item{features.two}{A GRanges object containing the second feature set of interest}

\item{feature.name.two}{The name of the second feature set of interest}
}
\value{
A data frame with one line for each range in `features'
}
\description{
This function will calculate the number of observed interactions between
two sets of features provided by the end-user. This allows the summarisation
of the number of features of a specific type a particular region is involved in 
and how many interactions exist between them.
}
\examples{
data('hic_example_data')
data('mm9_refseq_promoters')
data('thymus_enhancers')
annotateInteractions(hic_example_data, list(promoter = mm9_refseq_promoters, enhancer = thymus_enh))
# can be slow so subset of features used for examples
p <- unique(unlist(head(regions(hic_example_data)$promoter.id)))
e <- unique(unlist(head(regions(hic_example_data)$enhancer.id)))
p <- p[!is.na(p)]
p <- mm9_refseq_promoters[p]
e <- e[!is.na(e)]
e <- thymus_enh[e]
ep_summary <- summariseByFeaturePairs(hic_example_data, p, 'promoter', e, 'enhancer')
}
