% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewPoints.R
\name{plotAvgViewpoint}
\alias{plotAvgViewpoint}
\title{Plot coverage around a set of virtual 4C viewpoints}
\usage{
plotAvgViewpoint(
  x,
  left_dist = 1e+05,
  right_dist = 1e+05,
  ylab = "Average signal",
  xlab = "Relative position",
  fix = "center",
  ...
)
}
\arguments{
\item{x}{A GInteractions object which is output from viewPoint}

\item{left_dist}{Distance 'left' of interactions to consider, in bp.}

\item{right_dist}{Distance 'right' of interactions to consider, in bp.}

\item{ylab}{Y axis label.}

\item{xlab}{X axis label.}

\item{fix}{One of 'center', 'start', 'end'. Passed to `resize`. Interaction 
distances are calculated relative to this part of the bait.}

\item{...}{additional arguments to plot}
}
\value{
Coverage that is plotted (invisibly)
}
\description{
Plots summarised coverage of interactions around a set of viewpoints, 
e.g. promoters. This function requires the output of `viewPoint()` as input.
}
\examples{
data(hic_example_data)
library(GenomicRanges)
pos <- GRanges(seqnames='chr15', ranges=IRanges(start=59477709, end=59482708))
region <- GRanges(seqnames='chr15', ranges=IRanges(start=58980209, end=59980208))
vp <- viewPoint(hic_example_data, pos, region)
plotAvgViewpoint(vp, left_dist = 1000000, right_dist = 100000)
}
