% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{makeGenomicInteractionsFromFile}
\alias{makeGenomicInteractionsFromFile}
\title{Function to create GenomicInteraction objects from a file}
\usage{
makeGenomicInteractionsFromFile(
  fn,
  type,
  experiment_name = "",
  description = "",
  chr_names = NULL
)
}
\arguments{
\item{fn}{Filename or, if type='hiclib', folder}

\item{type}{One of 'chiapet.tool', 'bed12', 'bedpe', 'hiclib', 'homer', 'bam', 'two.bams'.}

\item{experiment_name}{Experiment name.}

\item{description}{Description of experiment.}

\item{chr_names}{a vector of chromosome names in order, required for re-naming chromosomes for hiclib import}
}
\value{
a GenomicInteractions object
}
\description{
Function to create GenomicInteraction objects from a variety of files. The resulting objects contain information
on which genomic regions are interacting with each other, and the number of counts supporting each interaction.
It is also possible to store information on associated p-values and false-discovery rates (FDR).
It is possible to create GenomicInteractions objects for various datasets including Hi-C and ChIA-PET. It is possible
to read interactions from a variety of files including BAM files, bed files (BED12 and BEDPE) and from the output
from standard processing pipelines, such as HOMER and ChIA-PET tool. GenomicInteractions objects can also be created
using calls of the form \code{new('GenomicInteractions', ...)}. For hiclib, it expects the directory in which the files
extracted using h5dictToTxt.py from the hdf5 file are located, where as for all of the other file types it expects the full
filename. Note that recent versions of hiclib (2015-) cannot export the required data and so this function will only work with
older files. Hiclib support will be removed in the next version of GenomicInteractions.
}
\examples{

k562.rep1 <- makeGenomicInteractionsFromFile(
       system.file(package='GenomicInteractions', 'extdata', 'k562.rep1.cluster.pet3+.txt'),
       type='chiapet.tool', experiment_name='k562', description='k562 pol2 8wg16')

k562.rep1

}
