% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_binom_ligation_threshold}
\alias{get_binom_ligation_threshold}
\title{get self ligation threshold with binomial test}
\usage{
get_binom_ligation_threshold(
  GIObject,
  max.distance = 20000,
  bin.size = 500,
  p.cutoff = 0.05,
  adjust = "fdr",
  plot = TRUE
)
}
\arguments{
\item{GIObject}{a GInteractions object of paired end reads}

\item{max.distance}{The maximum distance to consider between reads. 
Reads further apart than this distance should be very unlikely to be
 self ligations.}

\item{bin.size}{Bin size in base pairs.}

\item{p.cutoff}{P value cut off for a significant difference from 50:50. Default: 0.05}

\item{adjust}{Method to use to adjust p values. Default: fdr. See `help(p.adjust)` for 
accepted values. Can also be NA for no adjustment.}

\item{plot}{TRUE by default. Whether to plot the percentage of reads 
on opposite strands vs difference and the binomial test p value vs distance.}
}
\value{
The cutoff in base pairs below which an interaction is likely to be a self ligation.
}
\description{
This function calculates a self ligation threshold according to 
a method based on that of Heidari et al., Genome Research, 2014. 
Briefly, paired reads are divided into in evenly spaced bins. For
each bin, the number of reads that are aligned to opposite strand
vs to the same strand is calculated. A binomial test is used to test
if this is significantly different from the 50:50 ratio expected by 
chance if all reads are real interactions.
}
