% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.igraph.R
\docType{methods}
\name{export.igraph}
\alias{export.igraph}
\alias{export.igraph,GInteractions-method}
\title{Export interactions to an igraph object.}
\usage{
export.igraph(GIObject)

\S4method{export.igraph}{GInteractions}(GIObject)
}
\arguments{
\item{GIObject}{A GInteractions object.}
}
\value{
a graph.data.frame representation of the GInteractions object
}
\description{
Exports a GInteractions object to graph.data.frame for use by igraph package. This uses unique anchors
as nodes and generates edges between them. For the resulting graph to be easily interpretable, anchors
should be non-overlapping. This should already be the case for HiC data (either binned or restriction
fragments), however ChIA-PET data can contain overlapping anchors, which may need to be reduced to
non-overlapping regions before graph export.
}
\examples{
data(hic_example_data)
ig <- export.igraph(hic_example_data)

}
