% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNodes.R
\name{annotateNodes}
\alias{annotateNodes}
\title{Annotate node regions}
\usage{
annotateNodes(
  node_regions,
  txdb,
  orgDb,
  upstream = 2000,
  downstream = 500,
  ...
)
}
\arguments{
\item{node_regions}{GRanges object represent regions interacted with nodes.}

\item{txdb}{An object of \link[GenomicFeatures:TxDb-class]{TxDb} to extract
gene information}

\item{orgDb}{An object of \link[AnnotationDbi:AnnotationDb-class]{OrgDb}
to extract gene symbols}

\item{upstream, downstream}{An integer(1) value indicating the number of bases
upstream or downstream from the transcription start site. For additional
details see \link[GenomicFeatures:transcripts]{promoters}.}

\item{...}{parameter can be passed to
\link[GenomicFeatures:transcripts]{genes}}
}
\value{
GRanges object with gene_id and symbols metadata.
}
\description{
Assign gene id and gene symbols to node regions by interacted.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene) ## for human hg19
library(org.Hs.eg.db) ## used to convert gene_id to gene_symbol
set.seed(123)
node_regions <- createRandomNodes(TxDb.Hsapiens.UCSC.hg19.knownGene)
annotateNodes(node_regions, TxDb.Hsapiens.UCSC.hg19.knownGene, org.Hs.eg.db)
}
