% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-plots.R
\name{calcDinuclFreq}
\alias{calcDinuclFreq}
\title{Calculate Dinuclotide content over genomic ranges}
\usage{
calcDinuclFreq(query, ref, rawCounts = FALSE)
}
\arguments{
\item{query}{A GRanges object with query sets}

\item{ref}{Reference genome BSgenome object}

\item{rawCounts}{a logical indicating whether the raw numbers should be 
displayed, rather than percentages (optional).}
}
\value{
A data.table with counts of dinucleotides across the GRanges object
}
\description{
Given a reference genome (BSgenome object) and ranges on the
reference, this function returns a data.table with 
counts of dinucleotides within the GRanges object.
}
\examples{
\dontrun{ 
bsg = loadBSgenome('hg19')
DNF = calcDinuclFreq(vistaEnhancers, bsg)
}
}
