% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2chr.R
\name{str2chr}
\alias{str2chr}
\alias{str2chr,character-method}
\alias{str2chr,list-method}
\title{String to Character}
\usage{
str2chr(x, split = "", ...)

\S4method{str2chr}{character}(x, split = "", ...)

\S4method{str2chr}{list}(x, split = "", num.cores = 1L, tasks = 0L, verbose = FALSE, ...)
}
\arguments{
\item{x}{A character string or a list/vector of character strings.}

\item{split}{The same as in \code{\link[base]{strsplit}}}

\item{...}{Further parameters for \code{\link[base]{strsplit}}.}

\item{num.cores, tasks}{Parameters for parallel computation using package
\code{\link[BiocParallel]{BiocParallel-package}}: the number of cores to
use, i.e. at most how many child processes will be run simultaneously
(see \code{\link[BiocParallel]{bplapply}} and the number of tasks per job
(only for Linux OS).}

\item{verbose}{If TRUE, prints the function log to stdout.}
}
\value{
A character string
}
\description{
A simple function to transform a string into character vector.
}
\examples{
## A character string
str2chr("ATCAGCGGGATCTT")

## A list of character strings
str2chr(list(str1 = "ATCAGCGGGATCTT", str2 = "CTTCTTCGTCAGGC"))
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
