% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_covid_autm.R
\docType{data}
\name{covid_autm}
\alias{covid_autm}
\title{Automorphisms between DNA Sequences from two COVID-19 genomes}
\format{
\code{\link{AutomorphismList}} class object.
}
\usage{
data("covid_autm", package = "GenomAutomorphism")
}
\description{
This is a \link{AutomorphismList} object carrying a list of pairwise
automorphisms between the SARS coronavirus GZ02 (GenBank: AY390556.1:
265-13398_13398-21485) and Bat SARS-like coronavirus isolate bat-SL-CoVZC45
(GenBank: KY417151.1: protein-coding regions). The pairwise
DNA sequence alignment is available in the dataset named
\link{covid_aln} and the automorphisms were estimated with function
\link{autZ64}.
}
\examples{
data("covid_autm", package = "GenomAutomorphism",
    envir = environment())
covid_autm

}
\seealso{
\link{brca1_autm}, \link{brca1_autm2}, \link{cyc_autm}, and \link{covid_aln}.
}
\author{
Robersy Sanchez \url{https://genomaths.com}
}
\keyword{datasets}
