% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conserved_regions.R
\name{conserved_regions}
\alias{conserved_regions}
\alias{conserved_regions,Automorphism-method}
\alias{conserved_regions,AutomorphismList-method}
\alias{conserved_regions,AutomorphismByCoef-method}
\alias{conserved_regions,AutomorphismByCoefList-method}
\title{Conserved and Non-conserved Regions from a MSA}
\usage{
conserved_regions(x, ...)

\S4method{conserved_regions}{Automorphism}(
  x,
  conserved = TRUE,
  output = c("all_pairs", "unique_pairs", "unique")
)

\S4method{conserved_regions}{AutomorphismList}(
  x,
  conserved = TRUE,
  output = c("all_pairs", "unique_pairs", "unique"),
  num.cores = multicoreWorkers(),
  tasks = 0L,
  verbose = FALSE
)

\S4method{conserved_regions}{AutomorphismByCoef}(
  x,
  conserved = TRUE,
  output = c("all_pairs", "unique_pairs", "unique")
)

\S4method{conserved_regions}{AutomorphismByCoefList}(
  x,
  conserved = TRUE,
  output = c("all_pairs", "unique_pairs", "unique")
)
}
\arguments{
\item{x}{A \code{\link{Automorphism-class}}, a
\code{\link{AutomorphismList-class}},
a \code{\link{AutomorphismByCoef}} or a
\code{\link{AutomorphismByCoefList}} class object.}

\item{...}{Not in use.}

\item{conserved}{Logical, Whether to return the \emph{conserved} or the
\emph{non-conserved regions}.}

\item{output}{A character string. Type of output.}

\item{num.cores, tasks}{Integers. Argument \emph{num.cores} denotes the
number of cores to use, i.e. at most how many child processes will be run
simultaneously (see \code{\link[BiocParallel]{bplapply}} function from
BiocParallel package). Argument \emph{tasks} denotes the number of tasks per
job. value must be a scalar integer >= 0L. In this documentation a job is
defined as a single call to a function, such as
\code{\link[BiocParallel]{bplapply}}. A task is the division of the \eqn{X}
argument into chunks. When tasks == 0 (default), \eqn{X} is divided as
evenly as possible over the number of workers (see
\code{\link[BiocParallel]{MulticoreParam}} from BiocParallel package).}

\item{verbose}{logic(1). If TRUE, enable progress bar.}
}
\value{
A \code{\link{AutomorphismByCoef}} class object containing the
requested regions.
}
\description{
Returns the Conserved or the Non-conserved Regions from a MSA.
}
\examples{
## Load dataset
data("autm", package = "GenomAutomorphism")
conserved_regions(autm[1:3])
## Load automorphism found COVID datatset
data("covid_autm", package = "GenomAutomorphism")

## Conserved regions in the first 100 codons
conserv <- conserved_regions(covid_autm[1:100], output = "unique")
conserv
}
