% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_autby_coef.R
\docType{data}
\name{autby_coef}
\alias{autby_coef}
\title{Automorphisms between DNA Primate BRCA1 Genes Grouped by Coefficients}
\format{
\link{AutomorphismByCoefList} class object.
}
\usage{
data("autby_coef", package = "GenomAutomorphism")
}
\description{
This is a \link{AutomorphismList} object carrying a list of pairwise
automorphisms between the DNA sequences from the MSA of primate somatic
cytochrome C grouped by automorphism's coefficients. The grouping derives
from the dataset \link{brca1_autm} after applying function
\link{automorphism_bycoef}.
}
\examples{
## Load the data set
data("autby_coef", package = "GenomAutomorphism")
autby_coef

## Mutation type found in the data
unique(autby_coef$human_1.human_2$mut_type)

}
\keyword{datasets}
