% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{GRangesMatrixSeq-class}
\alias{GRangesMatrixSeq-class}
\alias{GRangesMatrixSeq}
\alias{DNAStringSet_OR_DNAMultipleAlignment-class}
\title{Definition of GRangesMatrixSeq-class}
\usage{
GRangesMatrixSeq(
  object = NULL,
  seqnames = Rle(factor()),
  start = integer(0),
  end = integer(0),
  ranges = IRanges(),
  strands = Rle(strand()),
  elementMetadata = DataFrame(),
  seqinfo = NULL,
  seqs = character(),
  names = character(),
  aaindex = character(),
  phychem = character(),
  accession = character()
)
}
\arguments{
\item{object}{If provided, it must be a GRangesMatrixSeq-class object and
in this case}

\item{seqnames, start, end, ranges, strand, elementMetadata, seqinfo}{The same as
in \code{\link[GenomicRanges]{GRanges}}}

\item{seqs, names, aaindex, phychem, accession}{The same as in
\link{MatrixSeq}.}
}
\value{
Given the slot values, it defines a MatrixList-class.

Only used to specify signature in the S4 setMethod.
}
\description{
This is a very simple flexible class to store DNA and
aminoacid aligned sequences together with their physicochemical properties.
That is, a place where each aminoacid or codon from the sequence is
represented by numerical value from a physicochemical index.

Constructor for 'GRangesMatrixSeq-class' object.
}
\details{
This is a convenient function to transform a \link{MatrixSeq}-class object
returned by function \link{aa_phychem_index} into a 'GRangesMatrixSeq-class'
object. Since a 'GRangesMatrixSeq-class' inherits from
\code{\link[GenomicRanges]{GRanges-class}}, this transformation permits the
application of several methods from GenomicRanges package in the downstream
analysis.
}
\examples{
aln <- c(S1 = "ATGCGGATTAGA", S2 = "ATGACGATCACA", 
        S3 = "ATGAGATCACAG")
cd <- DNAMultipleAlignment(aln)
r1 <- peptide_phychem_index(unmasked(cd), acc = "EISD840101")

r2 <- GRangesMatrixSeq(r1)
r2

slot(r2, "phychem")

}
\keyword{internal}
