% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_volcano.R
\name{gs_volcano}
\alias{gs_volcano}
\title{Volcano plot for gene sets}
\usage{
gs_volcano(
  res_enrich,
  gtl = NULL,
  p_threshold = 0.05,
  color_by = "aggr_score",
  volcano_labels = 10,
  scale_circles = 1,
  gs_ids = NULL,
  plot_title = NULL
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).
This object needs to be processed first by a function such as \code{\link[=get_aggrscores]{get_aggrscores()}}
to compute the term-wise \code{z_score} or \code{aggr_score}, which will be used for plotting}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{p_threshold}{Numeric, defines the threshold to be used for filtering the
gene sets to display. Defaults to 0.05}

\item{color_by}{Character specifying the column of \code{res_enrich} to be used
for coloring the plotted gene sets. Defaults to \code{aggr_score}.}

\item{volcano_labels}{Integer, maximum number of labels for the gene sets to be
plotted as labels on the volcano scatter plot.}

\item{scale_circles}{A numeric value, to define the scaling factor for the
circle sizes. Defaults to 1.}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be labeled.}

\item{plot_title}{Character string, used as title for the plot. If left \code{NULL},
it defaults to a general description of the plot and of the DE contrast}
}
\value{
A \code{ggplot} object
}
\description{
Volcano plot for gene sets, to summarize visually the functional enrichment
results
}
\details{
It is also possible to reduce the redundancy of the input \code{res_enrich} object,
if it is passed in advance to the \code{\link[=gs_simplify]{gs_simplify()}} function.
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

gs_volcano(res_enrich)
}
\seealso{
\code{\link[=gs_simplify]{gs_simplify()}} can be applied in advance to \code{res_enrich} to reduce
the redundancy of the displayed gene sets
}
