% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_heatmap.R
\name{gs_scores}
\alias{gs_scores}
\title{Compute gene set scores}
\usage{
gs_scores(se, res_de, res_enrich, annotation_obj = NULL, gtl = NULL)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object, or an object derived from this class,
such as a \code{DESeqTransform} object (variance stabilized transformed data, or
regularized logarithm transformed), in where the transformation has been applied
to make the data more homoscedastic and thus a better fit for visualization.}

\item{res_de}{A \code{DESeqResults} object.}

\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}
}
\value{
A matrix with the geneset Z scores, e.g. to be plotted with \code{\link[=gs_scoresheat]{gs_scoresheat()}}
}
\description{
Compute gene set scores for each sample, by transforming the gene-wise change
to a geneset-wise change
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

vst_macrophage <- vst(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

scores_mat <- gs_scores(
  vst_macrophage,
  res_de,
  res_enrich[1:50, ],
  anno_df
)
}
\seealso{
\code{\link[=gs_scoresheat]{gs_scoresheat()}} plots these scores
}
