% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_graph.R
\name{ggs_graph}
\alias{ggs_graph}
\title{Construct a gene-geneset-graph}
\usage{
ggs_graph(
  res_enrich,
  res_de,
  annotation_obj = NULL,
  gtl = NULL,
  n_gs = 15,
  gs_ids = NULL,
  prettify = TRUE,
  geneset_graph_color = "gold",
  genes_graph_colpal = NULL
)
}
\arguments{
\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. See more in the main function, \code{\link[=GeneTonic]{GeneTonic()}}, to check the
formatting requirements (a minimal set of columns should be present).}

\item{res_de}{A \code{DESeqResults} object.}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}

\item{n_gs}{Integer value, corresponding to the maximal number of gene sets to
be included}

\item{gs_ids}{Character vector, containing a subset of \code{gs_id} as they are
available in \code{res_enrich}. Lists the gene sets to be included in addition to
the top ones (via \code{n_gs})}

\item{prettify}{Logical, controlling the aspect of the returned graph object.
If TRUE (default value), different shapes of the nodes are returned, based on
the node type}

\item{geneset_graph_color}{Character value, specifying which color should be
used for the fill of the shapes related to the gene sets.}

\item{genes_graph_colpal}{A vector of colors, also provided with their hex
string, to be used as a palette for coloring the gene nodes. If unspecified,
defaults to a color ramp palette interpolating from blue through yellow to red.}
}
\value{
An \code{igraph} object to be further manipulated or processed/plotted (e.g.
via \code{\link[igraph:plot.igraph]{igraph::plot.igraph()}} or
\link[visNetwork:visNetwork-igraph]{visNetwork::visIgraph()})
}
\description{
Construct a gene-geneset-graph from the results of a functional enrichment
analysis
}
\examples{

library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

ggs <- ggs_graph(
  res_enrich,
  res_de,
  anno_df
)

ggs

# could be viewed interactively with
# library(visNetwork)
# library(magrittr)
# ggs \%>\%
#   visIgraph() \%>\%
#   visOptions(highlightNearest = list(enabled = TRUE,
#                                      degree = 1,
#                                      hover = TRUE),
#             nodesIdSelection = TRUE)
}
