% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_plot.R
\name{get_expression_values}
\alias{get_expression_values}
\title{Get expression values}
\usage{
get_expression_values(
  dds,
  gene,
  intgroup,
  assay = "counts",
  normalized = TRUE,
  gtl = NULL
)
}
\arguments{
\item{dds}{A \code{DESeqDataSet} object, normally obtained after running your data
through the \code{DESeq2} framework.}

\item{gene}{Character, specifies the identifier of the feature (gene) to be
extracted}

\item{intgroup}{A character vector of names in \code{colData(dds)} to use for grouping.}

\item{assay}{Character, specifies with assay of the \code{dds} object to use for
reading out the expression values. Defaults to "counts".}

\item{normalized}{Logical value, whether the expression values should be
normalized by their size factor. Defaults to TRUE, applies when \code{assay} is
"counts"}

\item{gtl}{A \code{GeneTonic}-list object, containing in its slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list \emph{must} be specified following the content they are expecting}
}
\value{
A tidy data.frame with the expression values and covariates for further
processing
}
\description{
Extract expression values, with the possibility to select other assay slots
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

df_exp <- get_expression_values(dds_macrophage,
  gene = "ENSG00000125347",
  intgroup = "condition"
)
head(df_exp)
}
