% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneTonic-extras.R
\name{check_colors}
\alias{check_colors}
\title{Check colors}
\usage{
check_colors(x)
}
\arguments{
\item{x}{A vector of strings specifying colors}
}
\value{
A vector of logical values, one for each specified color - \code{TRUE} if
the color is specified correctly
}
\description{
Check correct specification of colors
}
\details{
This is a vectorized version of \code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}
}
\examples{
# simple case
mypal <- c("steelblue", "#FF1100")
check_colors(mypal)
mypal2 <- rev(
  scales::alpha(
    colorRampPalette(RColorBrewer::brewer.pal(name = "RdYlBu", 11))(50), 0.4
  )
)
check_colors(mypal2)
# useful with long vectors to check at once if all cols are fine
all(check_colors(mypal2))
}
