% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWhippetFiles.R
\name{readWhippetDIFFfiles}
\alias{readWhippetDIFFfiles}
\title{Read in a list of whippet .diff.gz files and format as a data.frame}
\usage{
readWhippetDIFFfiles(files)
}
\arguments{
\item{files}{vector of *.diff.gz file names}
}
\value{
data.frame with junction counts for all files
}
\description{
Read in a list of whippet .diff.gz files and format as a data.frame
}
\examples{
whippetFiles <- list.files(system.file("extdata","whippet/",
package = "GeneStructureTools"), full.names = TRUE)
diffFiles <- whippetFiles[grep(".diff", whippetFiles)]
whippetDiffSplice <- readWhippetDIFFfiles(diffFiles)
}
\seealso{
Other whippet data processing: \code{\link{coordinates}},
  \code{\link{diffSplicingResults}},
  \code{\link{filterWhippetEvents}},
  \code{\link{formatWhippetEvents}},
  \code{\link{junctions}}, \code{\link{readCounts}},
  \code{\link{readWhippetDataSet}},
  \code{\link{readWhippetJNCfiles}},
  \code{\link{readWhippetPSIfiles}},
  \code{\link{whippetTranscriptChangeSummary}}
}
\author{
Beth Signal
}
