#' Gene Annotation hg18
#'
#' @description A dataset containing the gene locations based on human genome reference hg18 that was obtained from BioMart.
#'
#' @docType data
#' @keywords datasets
#' @name ens.gene.ann.hg18
#' @usage data( ens.gene.ann.hg18 )
#' @format A data.frame
#' @return data.frame
#' @details Dataframe with 5 columns:
#' \itemize{
#'   \item Gene: ensembl gene name
#'   \item EnsID: ensembl gene id
#'   \item Chromosome: Genomic Chromosome
#'   \item Start: Genomic start of gene
#'   \item End: Genomic end of gene
#' }
NULL

#' Gene Annotation hg19
#'
#' @description A dataset containing the gene locations based on human genome reference hg19 that was obtained from BioMart.
#'
#' @docType data
#' @keywords datasets
#' @name ens.gene.ann.hg19
#' @usage data( ens.gene.ann.hg19 )
#' @format A data.frame
#' @return data.frame
#' @details Dataframe with 5 columns:
#' \itemize{
#'   \item Gene: ensembl gene name
#'   \item EnsID: ensembl gene id
#'   \item Chromosome: Genomic Chromosome
#'   \item Start: Genomic start of gene
#'   \item End: Genomic end of gene
#' }
NULL

#' Gene Annotation hg38
#'
#' @description A dataset containing the gene locations based on human genome reference hg38 that was obtained from BioMart.
#'
#' @docType data
#' @keywords datasets
#' @name ens.gene.ann.hg38
#' @usage data( ens.gene.ann.hg38 )
#' @format A data.frame
#' @return data.frame
#' @details Dataframe with 5 columns:
#' \itemize{
#'   \item Gene: ensembl gene name
#'   \item EnsID: ensembl gene id
#'   \item Chromosome: Genomic Chromosome
#'   \item Start: Genomic start of gene
#'   \item End: Genomic end of gene
#' }
NULL

#' CGHcall Example copynumber data hg18 chr18
#' @description A test dataset containing copynumber data of chromosome 18 for the GeneBreak package (hg18 based). This copy number aberration (CNA) data was obtained by analysis of 200 array-CGH (Agilent 180k) samples from advanced colorectal cancers.
#'
#' @docType data
#' @keywords datasets
#' @name copynumber.data.chr18
#' @usage data( copynumber.data.chr18 )
#' @format An object of class cghCall
#' @return An object of class cghCall
NULL

#' CGHcall Example copynumber data hg18 chr20
#' @description A test dataset containing chromosome 20 copynumber data for the GeneBreak package (hg18 based). This copy number aberration (CNA) data was obtained by analysis of 200 array-CGH (Agilent 180k) samples from advanced colorectal cancers.
#'
#' @docType data
#' @keywords datasets
#' @name copynumber.data.chr20
#' @usage data( copynumber.data.chr20 )
#' @format An object of class cghCall
#' @return An object of class cghCall

NULL

#' CGHcall Example copynumber data hg18 chr21
#' @description A test dataset containing chromosome 21 copynumber data for the GeneBreak package (hg18 based). This copy number aberration (CNA) data was obtained by analysis of 200 array-CGH (Agilent 180k) samples from advanced colorectal cancers.
#'
#' @docType data
#' @keywords datasets
#' @name copynumber.data.chr21
#' @usage data( copynumber.data.chr21 )
#' @format An object of class cghCall
#' @return An object of class cghCall
NULL
