% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMM_Scoring.R
\name{pMMlocal}
\alias{pMMlocal}
\title{Calculate local pMM distance}
\usage{
pMMlocal(a, b, ppi, maxInteract, alpha)
}
\arguments{
\item{a, b}{character vector, set of gene identifiers.}

\item{ppi}{a \code{data.frame}, Protein-protein interaction (PPI) network data
frame. The object is expected to have three columns, \code{Gene1} and
\code{Gene2} which specify the gene names of the interacting proteins
in no particular order (symmetric interaction) and a column
\code{combined_score} which is a numerical value of the strength of
the interaction.}

\item{maxInteract}{numeric, Maximum interaction value in the PPI.}

\item{alpha}{numeric, Scaling factor for controlling the influence of the
interaction score. Defaults to 1.}
}
\value{
The pMMlocal score between the two gene sets.
}
\description{
Calculate the local pMM distance of two genesets.
}
\examples{
## Mock example showing how the data should look like
a <- c("PDHB", "VARS2")
b <- c("IARS2", "PDHA1")

ppi <- data.frame(
  Gene1 = c("PDHB", "VARS2"),
  Gene2 = c("IARS2", "PDHA1"),
  combined_score = c(0.5, 0.2)
)
maxInteract <- max(ppi$combined_score)

pMM_score <- pMMlocal(a, b, ppi, alpha = 1,  maxInteract)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
data(ppi_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
maxInteract <- max(ppi_macrophage_topGO_example_small$combined_score)

pMMlocal <- pMMlocal(genes[1], genes[2], ppi, alpha = 1,  maxInteract)
}
\references{
See https://doi.org/10.1186/s12864-019-5738-6 for details on the original
implementation.
}
