% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_PPI.R
\name{getId}
\alias{getId}
\title{Get NCBI ID}
\usage{
getId(species, version = "12.0", cache = FALSE)
}
\arguments{
\item{species}{character, the species of your input data}

\item{version}{character, the version of STRING you want to use, defaults to
the current version of STRING}

\item{cache}{Logical value, defining whether to use the
BiocFileCache for retrieval of the files underlying
the \code{STRINGdb} object. Defaults to \code{TRUE}.}
}
\value{
A character of the NCBI ID of \code{species}
}
\description{
Get the NCBI ID of a species
}
\examples{
species <- "Homo sapiens"
id <- getId(species = species)

species <- "Mus musculus"
id <- getId(species = species)
}
